<!DOCTYPE html>
<html>
<head>
<title>How to Convert MySQL Date and Time to Another Format in PHP</title>
</head>
<body>
	<?php
		include('conn.php');
		//MySQLi Object-oriented
		//$query = $conn->query("select * from `date` where dateid='1'");
		//$row = $query->fetch_assoc();
		
		//MySQLi Procedural
		$query=mysqli_query($conn,"select * from `date` where dateid='1'");
		$row=mysqli_fetch_assoc($query);
	?>
	<h2>Our Date: <?php echo $row['date_time']; ?></h2>
	Some Symbols to Consider: 
		<ul>
			<li>Y : returns a four-digit year</li>
			<li>y : returns a two-digit year</li>
			<li>M : returns the first three letters of a month</li>
			<li>m : returns two digit numerical representation of a month</li>
			<li>F : Full letter representation of a month</li>
			<li>D : returns the first three letters of a day in a week</li>
			<li>d :	returns two digit numerical representation of a day</li>
			<li>H :	returns 24-hour clock</li>
			<li>h :	returns 12-hour clock</li>
			<li>i :	number of minutes</li>
			<li>s :	number of seconds</li>
			<li>A :	add AM/PM</li>
		</ul>	
	<h2>Example Convertions:</h2>
	<?php
	
	//MySQLi Object-oriented
	//$date = new DateTime($row['date_time']);
	//echo $date->format('Y-m-d H:i:s')."<br>";
	//echo $date->format('y-M-d h:i:s')."<br>";
	//echo $date->format('F d, Y h:i A - D');

	//MySQLi Procedural
	$date = date_create($row['date_time']);
	echo date_format($date, 'Y-m-d H:i:s')."<br>";
	echo date_format($date, 'y-M-d h:i:s')."<br>";
	echo date_format($date, 'F d, Y h:i A - D');
	
	?>
</body>
</html>