<?php

session_start();

include_once('Converter.php');

$converter = new Converter();

$rates = $converter->getRates();

?>
<!DOCTYPE html>
<html>
<head>
	<title>Simple Currency Converter in PHP</title>
	<link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container">
	<h1 class="page-header text-center">Simple Currency Converter in PHP</h1>
	<div class="row">
		<div class="col-sm-4 col-sm-offset-4">
			<form method="POST" action="getconvert.php">
				<div class="form-group">
					<label>Amount:</label>
					<input type="text" class="form-control" name="amount">
				</div>
				<div class="form-group">
					<label>From:</label>
					<select class="form-control" name="currency_from">
						<?php
							foreach ($rates as $key => $currency){
								?>
								<option value="<?php echo $key; ?>"><?php echo $key ?></option>
								<?php
							}

						?>
					</select>
				</div>
				<div class="form-group">
					<label>To:</label>
					<select class="form-control" name="currency_to">
						<?php
							foreach ($rates as $key => $currency){
								?>
								<option value="<?php echo $key; ?>"><?php echo $key ?></option>
								<?php
							}

						?>
					</select>
				</div>
				<button type="submit" name="convert" class="btn btn-primary">Convert</button>
			</form>

			<?php
				if(isset($_SESSION['value'])){
					?>
					<div class="alert alert-info text-center" style="margin-top:20px;">
						<?php 
							echo $_SESSION['value']['amount'].' '.$_SESSION['value']['from'].' is equal to '.$_SESSION['value']['result'].' '.$_SESSION['value']['to']; 
						?>
					</div>
					<?php
					unset($_SESSION['value']);
				}
			?>
		</div>
	</div>
</div>
</body>
</html>